<?
// fetchevents.php
// Case Study 2 - Foundation PHP for Flash

// Include config file
include("common.php");

// Connect to database
$link = dbConnect();

// Decide which action to take
switch($action) {
    // Get event counts for year view
    case "geteventcounts":
        getEventCounts($year);
        break;
        
    // Get event details for month view
    case "geteventdetails":
        getEventDetails($year, $month);
        break;
        
    default:
        // Output error info to Flash and quit
        fail("Unknown action $action");
        break;
}

// Close database connection
mysql_close($link);


function getEventCounts($year) {
    // Register global variables
    global $table;
    
    // Build query to fetch all events for year.
    $query = "SELECT month FROM $table WHERE year=$year";

    // Execute query
    $result = @mysql_query($query);

    // If the query failed...
    if (!$result) {
        // Output error information to Flash and quit
        fail("Unable to fetch event information");
    }
    
    // Setup array to hold event counts
    $eventCounts = array(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
    
    // For each event returned...
    while($event = mysql_fetch_array($result)) {
        // Extract the month for the event
        $month = $event['month'];
        
        // Incremenet the relevant element of our array
        $eventCounts[$month]++;
    }
        
    // For each month of the year...
    for ($count = 0; $count < 12; $count++) {
        // Output event count information to Flash
        print "&eventCount" . $count . "=" . $eventCounts[$count];
    }
    
    // Output success
    print "&result=Okay";
}

function getEventDetails($year, $month) {
    // Register global variables
    global $table;

    // Build query to fetch all events for month of year.
    $query = "SELECT * FROM $table WHERE year=$year AND month=$month ORDER BY day ASC";

    // Execute query
    $result = @mysql_query($query);

    // If the query failed...
    if (!$result) {
        // Output error information to Flash and quit
        fail("Unable to fetch event information");
    }
    
    // Setup count for output
    $count = 0;
    
    // For each event returned...
    while($event = mysql_fetch_array($result)) {
        // Extract the event information
        $day = $event['day'];
        $title = stripslashes($event['title']);
        $event = stripslashes($event['event']);
        
        // Output information to Flash
        print "&event" . $count . "day=" . $day;
        print "&event" . $count . "title=" . urlencode($title);
        print "&event" . $count . "event=" . urlencode($event);
        
        // Next event
        $count++;
    }
    
    // Output number of events to Flash
    print "&eventCount=$count";
    
    // Output success
    print "&result=Okay";
}  
?>